/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.mixins;

import net.minecraft.world.entity.LivingEntity;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.config.ModConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract float getHealth();

    @Inject(method={"getFrictionInfluencedSpeed(F)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetMovementSpeed(CallbackInfoReturnable<Float> cir) {
        if (Freecam.isEnabled() && ModConfig.INSTANCE.movement.flightMode.equals((Object)ModConfig.FlightMode.CREATIVE) && this.equals((Object)Freecam.getFreeCamera())) {
            cir.setReturnValue((Object)Float.valueOf((float)(ModConfig.INSTANCE.movement.horizontalSpeed / 10.0) * (float)(Freecam.getFreeCamera().isSprinting() ? 2 : 1)));
        }
    }

    @Inject(method={"setHealth(F)V"}, at={@At(value="HEAD")})
    private void onSetHealth(float health, CallbackInfo ci) {
        if (Freecam.isEnabled() && ModConfig.INSTANCE.utility.disableOnDamage && this.equals(Freecam.MC.player) && !Freecam.MC.player.isCreative() && this.getHealth() > health) {
            Freecam.disableNextTick();
        }
    }
}

